function GUI_START_hydropower_optimization

% fig_hydropower_gui=figure('Visible','on','Position',[300,70,900,650],...
%     'numbertitle','off',...
%     'name','SMALL HYDROPOWER PLANT (Run-of-River)',...
%     'menubar','none',...
%     'resize','on','color',[1 1 1]);

screen_size=get(0, 'ScreenSize');

fig_hydropower_gui=figure('Visible','on','Position',[1,1,screen_size(3),screen_size(4)],...
    'numbertitle','off',...
    'name','SMALL HYDROPOWER PLANT (Run-of-River)',...
    'menubar','none',...
    'resize','on','color',[1 1 1]);

axes('visible','on','position',[0  0.22  1  0.6],...
     'units','normalized');
    
im = imread('Scheme.jpg');
imshow(im);

uipanel('units','normalized',...
        'position',[0.24    0.93   0.52    0.04],'backgroundcolor',[1 1 1]);
        
uicontrol('Style','text',...
    'string',{'SMALL HYDROPOWER PLANT (Run-of-River)'},...
    'fontsize',10,...
    'units','normalized',...
    'position',[0.25  0.94  0.5    0.023],'backgroundcolor',[1 1 1]);
%    'position',[0.41   0.94  0.18    0.02],'backgroundcolor',[1 1 1]);

%    'string',{'Goal : find the optimal water allocation policies';'that maximize energy production and preserve riverine ecosystem'},...
uicontrol('Style','text',...
    'string',{'Goal: Find the optimal water allocation policies that maximize energy production and preserve riverine ecosystem'},...    
    'horizontalalignment','center',...
    'fontsize',15,...
    'units','normalized',...
    'position',[0.1   0.84  0.8    0.08],'backgroundcolor',[1 1 1],'ForegroundColor',[1 0 0]);

uicontrol('Style','text',...
    'string',{'Method: This model simulate different water repartition rules applied at the water intake, in the case of a small hydropower plant.';...
    'Results are presented as an efficiency plot showing, for each scenario, the Environmental Indicator vs the Energy Produced'},...    
    'horizontalalignment','left',...
    'fontsize',12,...
    'units','normalized',...
    'position',[0.16   0.827  0.8    0.05],'backgroundcolor',[1 1 1]);

uicontrol('Style','text',...
    'string',{'I(t): Natural flow discharge';'Q1(t): Worked flow, diverted to the powerhouse';'Q2(t): Residual flow, left to the river';'';'N: Water intake'},...    
    'horizontalalignment','left',...    
    'fontsize',12,...
    'units','normalized',...
    'position',[0.65  0.47  0.3    0.3],'backgroundcolor',[1 1 1]);

complete_msg=uicontrol('Style','text',...
    'string',{'Complete all the fields before you can launch the simulations'},...    
    'horizontalalignment','center',...
    'fontsize',9,...
    'units','normalized',...
    'position',[0.1   0.01  0.8    0.08],'backgroundcolor',[1 1 1],'ForegroundColor',[1 0 0]);

uicontrol('Style','text',...
    'string',{'Developed by the group AHEAD'},...    
    'horizontalalignment','center',...
    'fontsize',6,...
    'units','normalized',...
    'position',[0.64  0  0.5  0.05],'backgroundcolor',[1 1 1],'ForegroundColor',[0 0 0]);


data=[];
set(fig_hydropower_gui, 'UserData',data);

hydrology=uicontrol('Style','push',...
    'string','River natural hydrograph',...
    'units','normalized',...
    'position',[0.17   0.63    0.2    0.04],'backgroundcolor',[0/255 0/255 139/255],...
    'foregroundcolor',[1 1 1],...
    'callback',{@GUI_riverdata,fig_hydropower_gui});

uicontrol('Style','push',...
    'string','?',...
    'units','normalized',...
    'backgroundcolor',[0/255 0/255 139/255],...
    'foregroundcolor',[1 1 1],...
    'position',[0.38    0.63    0.04    0.04],...
    'callback',@helpA);

    function helpA(~,~)
       % figure('Visible','on','Position',[700,500,180,80],...
        figure('Visible','on','Position',[screen_size(3)/2,screen_size(4)/2,180,80],...
            'numbertitle','off',...
            'name','Help',...
            'menubar','none',...
            'resize','on','color',[0.8 0.8 0.8]);
        uicontrol('Style','text','String','Here you have to load the daily flow of the river [m3/s]. A minimum period of 20 years is required.',...
            'units','normalized',...
            'position',[0.1   0.1    0.8    0.8],'background',[0.8 0.8 0.8]);
    end

water_allocation=uicontrol('Style','push',...
    'string','Water allocation policies',...
    'units','normalized',...
    'position',[0.47   0.53    0.2    0.04],'backgroundcolor',[178/255 25/255 54/255],...
    'foregroundcolor',[1 1 1],...
    'callback',{@GUI_waterallocation,fig_hydropower_gui});

uicontrol('Style','push',...
    'string','?',...
    'units','normalized',...
    'position',[0.68   0.53    0.04    0.04],'backgroundcolor',[178/255 25/255 54/255],...
    'foregroundcolor',[1 1 1],...
    'callback',@helpB);


    function helpB(~,~)
        figure('Visible','on','Position',[screen_size(3)/2,screen_size(4)/2,180,130],...
            'numbertitle','off',...
            'name','Help',...
            'menubar','none',...
            'resize','on','color',[0.8 0.8 0.8]);
        uicontrol('Style','text','String','Here you have to insert the minimal flow release and to select the water allocation policies you want to test (and for each of them you have to provide the necessary data). ',...
            'units','normalized',...
            'position',[0.1   0.1    0.8    0.8],'background',[0.8 0.8 0.8]);
    end

ecosystem=uicontrol('Style','push',...
    'string','Habitat suitability thresholds',...
    'units','normalized',...
    'position',[0.17   0.28    0.2    0.04],'backgroundcolor',[34/255 139/255 34/255],...
     'foregroundcolor',[1 1 1],...
     'callback',{@GUI_ecologicaldata,fig_hydropower_gui});
 
 uicontrol('Style','push',...
    'string','?',...
    'units','normalized',...
    'position',[0.38   0.28    0.04    0.04],'backgroundcolor',[34/255 139/255 34/255],...
     'foregroundcolor',[1 1 1],...
    'callback',@helpC);


    function helpC(~,~)
        figure('Visible','on','Position',[screen_size(3)/2,screen_size(4)/2,180,120],...
            'numbertitle','off',...
            'name','Help',...
            'menubar','none',...
            'resize','on','color',[0.8 0.8 0.8]);
        uicontrol('Style','text','String','Here you have to indicate the flow threshold for fitness and survival of joung and adult fishes. To do that you need the weighted usable area WUA curves both for juvenile and adult fishes.',...
            'units','normalized',...
            'position',[0.1   0.1    0.8    0.8],'background',[0.8 0.8 0.8]);
    end

powerplant=uicontrol('Style','push',...
    'string','Hydropower plant data',...
    'units','normalized',...
    'position',[0.6   0.45   0.2    0.04],'backgroundcolor',[110/255 110/255 110/255],...
     'foregroundcolor',[1 1 1],...
     'callback',{@GUI_powerplantdata,fig_hydropower_gui});

  uicontrol('Style','push',...
    'string','?',...
    'units','normalized',...
    'position',[0.81   0.45    0.04    0.04],'backgroundcolor',[110/255 110/255 110/255],...
     'foregroundcolor',[1 1 1],...
    'callback',@helpD);

    function helpD(~,~)
        figure('Visible','on','Position',[screen_size(3)/2,screen_size(4)/2,180,70],...
            'numbertitle','off',...
            'name','Help',...
            'menubar','none',...
            'resize','on','color',[0.8 0.8 0.8]);
        uicontrol('Style','text','String','Here you have to insert the technical data about the SHPP.',...
            'units','normalized',...
            'position',[0.1   0.1    0.8    0.8],'background',[0.8 0.8 0.8]);
    end

results=uicontrol('Style','push',...
    'string','EVALUATION OF THE DIFFERENT FLOW REDISTRIBUTION POLICIES - DISPLAY THE EFFICIENCY PLOT',...
    'units','normalized',...
    'position',[0.2    0.1   0.6    0.06],'Enable','on','callback',{@GUI_res,fig_hydropower_gui});

end


